<?php

namespace app\controller;

use app\BaseController;
use think\facade\View;
use think\facade\Db;
use think\facade\Request;
use think\facade\Session;
use think\facade\Cookie;

class Index extends BaseController
{
    public function index()
    {
        //host_name();
        load_lanmu_session();

        //箴言随机显示
        $info_zhenyan = DB::name("zhenyan")
        ->orderRand()
        ->limit(1)
        ->find();
        View::assign("info_zhenyan",$info_zhenyan);

        //成就榜
        $info_chengjiu = DB::name("user")
        ->order('chengjiu','desc')
        ->limit(5)
        ->select();
        View::assign("info_chengjiu",$info_chengjiu);

        //考试日历
        $info_rili = DB::name("rili")
        ->order('test_date','asc')
        ->limit(3)
        ->select();
        View::assign("info_rili",$info_rili);

        //行测
        $info_class = DB::name("class")->where('father_name','行测')->select();
        $arr_class = [];
        foreach ($info_class as $class) {
            $arr_class[] = $class['id'];
        }
        $where_xc = [
            ['class', 'in', $arr_class],
            ['flag', '=', 1]
            
        ];
        
        $info_xc = DB::name("article")
        ->field('id,title,question_nums,date')
        ->where($where_xc)
        ->order('id','desc')
        ->limit(5)
        ->select();
        View::assign("info_xc",$info_xc);

         //申论
         $info_class2 = DB::name("class")->where('father_name','申论')->select();
         $arr_class2 = [];
         foreach ($info_class2 as $class2) {
             $arr_class2[] = $class2['id'];
         }
         $where_sl = [
             ['class', 'in', $arr_class2],
             ['flag', '=', 1]
             
         ];
         
         $info_sl = DB::name("article")
         ->field('id,title,question_nums,date')
         ->where($where_sl)
         ->order('id','desc')
         ->limit(5)
         ->select();
         View::assign("info_sl",$info_sl);

         //热点
         $info_class3 = DB::name("class")->where('father_name','热点')->select();
         $arr_class3 = [];
         foreach ($info_class3 as $class3) {
             $arr_class3[] = $class3['id'];
         }
         $where_rd = [
             ['class', 'in', $arr_class3],
             ['flag', '=', 1]
           
         ];
         
         $info_rd = DB::name("article")
         ->field('id,title,zhuti,thumb,date')
         ->where($where_rd)
         ->order('id','desc')
         ->limit(6)
         ->select();
         View::assign("info_rd",$info_rd);



        return View::fetch();
    }

    public function login()
    {
        return View::fetch();
    }

    public function register()
    {
        return View::fetch();
    }
    public function xieyi()
    {
        return View::fetch();
    }

    public function list()
    {
        //host_name();
        load_lanmu_session();

        //接收父ID
        $id = Request::param('id');
        $fname = Db::name('class')->where('id',$id)->field('name')->find();
        if($fname==null){
            header('location:/');
            exit;
        }
        View::assign("father_id",$id);
        View::assign("father_name",$fname['name']);


        //接收子ID
        $id_c = Request::param('id_c');
        if($id_c == ""){
            //查询第一个子id
            $child_id = Db::name('class')->where('father_id',$id)->field('id,name,muban,jieshao')->order('sort','asc')->find();
            if($child_id==null){
                header('location:/');
                exit;
            }
            $id_c = $child_id['id'];
            View::assign("child_id",$child_id['id']);
            View::assign("child_name",$child_id['name']);
            View::assign("muban",$child_id['muban']);
            View::assign("jieshao",$child_id['jieshao']);
        }else{
            $child_name = Db::name('class')->where('id',$id_c)->field('name,muban,jieshao')->find();
            if($child_name==null){
                header('location:/');
                exit;
            }
            View::assign("child_name",$child_name['name']);
            View::assign("child_id",$id_c);
            View::assign("muban",$child_name['muban']);
            View::assign("jieshao",$child_name['jieshao']);
        }
        
        //加载子栏目
        $info2 = Db::name('class')->where('father_id',$id)->field('id,name')->order('sort','asc')->select();
        View::assign("info2",$info2);


        //分页数据查询
        $where = array(
            'flag' => 1,
            'class' => $id_c
        );
        $list = Db::name('article')->where($where)
        ->alias('a')
        ->join('class c','a.class = c.id')
        ->field('a.id,a.title,a.date,c.name,c.father_id,c.father_name,a.views,a.collect,a.zhuti,a.question_nums,a.thumb')
        ->order('a.id','desc')
        ->paginate(10);
        //分页赋值
        View::assign("list",$list);
        return View::fetch();
    }

    public function article()
    {
        //host_name();
        load_lanmu_session();
        
        //接收ID
        $id = Request::param('id');
        $where= [
            'id' => $id,
            'flag' => 1
        ];
        $info2 = Db::name('article')->where($where)->find();
        if($info2==null){
            header('location:/');
            exit;
        }
        View::assign("info2",$info2);

        //查询父栏目名称和子栏目名称
        $class = $info2['class'];
        $info3 = Db::name('class')->where('id',$class)->field('id,father_id,father_name,name')->find();
        View::assign("info3",$info3);

        

        //浏览次数计算
        //每个文章记录一个cookie
        $article_cookie = 'view_flag'.$id;
        if(Cookie::get($article_cookie) == null){
            Cookie::set($article_cookie, '1', 3600*12);
            Db::name('article')->where('id',$id)->inc('views')->update();
        }
        
        //查询文章是否被收藏
        $username = Session::get('username');
        if($username != null){
            $where_collect= [
                'article_id' => $id,
                'username' => $username
            ];
            $info_collect = Db::name('collect')->where($where_collect)->find();
            if($info_collect !== null){
                View::assign("is_collect",1);
            }else{
                View::assign("is_collect",0);
            }
        }else{
            View::assign("is_collect",0);
        }

        //每日浏览文章成就值计算
        if($username != null){
            $date1 = date("Y-m-d").'%';
            $date2 = date("Y-m-d H:i:s");
            $where_cj = [
                ['username', '=', $username],
                ['leibie', '=', 2],
                ['date', 'like', $date1]
            ];
            $where_cj2 = [
                ['username', '=', $username],
                ['leibie', '=', 2],
                ['date', 'like', $date1],
                ['article_id', '=', $id]
            ];
            $insert_cj = [
                'username' => $username,
                'leibie' => 2,
                'date' => $date2,
                'article_id' => $id
            ];
            $info_liulan = Db::name('chengjiu')->where($where_cj)->count();
            $info_liulan2 = Db::name('chengjiu')->where($where_cj2)->find();
            if($info_liulan < 5 && !$info_liulan2){
                Db::name('chengjiu')->insert($insert_cj);
                Db::name('user')->where('username',$username)->inc('chengjiu',2)->update();
                View::assign("insert_cj",2);
            }else{
                View::assign("insert_cj",1);
            }
        }else{
            View::assign("insert_cj",0);
        }   
      
       
        return View::fetch();
    }

    public function userhome()
    {
        session_safe_user();
        load_lanmu_session();
        return View::fetch();
    }

    public function user_ziliao()
    {
        session_safe_user();

        $username = Session::get('username');
        $info_user = Db::name('user')->where('username',$username)->find();
        View::assign("info_user",$info_user);
        return View::fetch();
    }

    public function user_collect()
    {
        //session安全检查
        session_safe_user();
        //接收page
        $page = Request::param('page');
        //分页查询数据
        $username = Session::get('username');
        $where = [
            'username' => $username
        ];
        $list = Db::name('collect')->where($where)
        ->alias('c')
        ->join('article a','c.article_id = a.id')
        ->field("a.title,c.id,c.article_id,c.datetime")
        ->order('c.id','desc')
        ->paginate(10);
        $count = $list->total();
        //赋值
        View::assign("nowpage",$page);
        View::assign("list",$list);
        View::assign("total",$count);
        return View::fetch();
    }


    public function user_chengjiu()
    {
        //session安全检查
        session_safe_user();
        
        
        return View::fetch();
    }

   


    public function user_password()
    {
        session_safe_user();
        return View::fetch();
    }

    public function user_ziliao_update()
    {
        session_safe_user();
        $username = Session::get('username');
        $info_user = Db::name('user')->where('username',$username)->find();
        View::assign("info_user",$info_user);
        return View::fetch();
    }

    public function select_touxiang()
    {
        session_safe_user();
        return View::fetch();
    }

    public function search()
    {
        load_lanmu_session();
        //搜索
        $content = Request::param('search_content');
        $kewords = trim($content);
        $like = '%'.$content.'%';
        $where = [
            ['title', 'like', $like],
            ['flag', '=', 1]
            
        ];

        $list = Db::name('article')->where($where)
        ->alias('a')
        ->join('class c','a.class = c.id')
        ->field("a.id,a.title,a.zhuti,a.date,c.name,c.father_name")
        ->order('a.id','desc')
        ->paginate([
            'list_rows' => 10, // 每页显示的记录数
            'query' => ['search_content' => $kewords],//搜索内容参数
        ]);
        

        $count = count($list);

        View::assign("count",$count);
        View::assign("kewords",$kewords);
        View::assign("list",$list);
        return View::fetch();
    }


    public function user_chengjiu_duihuan(){
        //session安全检查
        session_safe_user();
        $username = Session::get('username');
        //获得成就值
        $info_chengjiu = Db::name("user")->where("username",$username)->field('chengjiu')->find();
        //查询是否领取通关文牒
        $where_daoju = [
            'leibie' => 1,
            'username' => $username
        ];
        $info_daoju = Db::name("daoju")->where($where_daoju)->count();
        if($info_daoju > 0){
            View::assign("has_tgwd",1);
        }else{
            View::assign("has_tgwd",0);
        }
        //赋值
        View::assign("chengjiu",$info_chengjiu['chengjiu']);
        return View::fetch();
    }

    public function user_chengjiu_guize(){
        //session安全检查
        session_safe_user();
        return View::fetch();
    }

    public function user_chengjiu_zlbk(){
        //session安全检查
        session_safe_user();
        //检查是否拥有通关文牒
        $username = Session::get('username');
        $where_daoju = [
            'leibie' => 1,
            'username' => $username
        ];
        $info_daoju = Db::name("daoju")->where($where_daoju)->count();
        if($info_daoju > 0){
            View::assign("has_tgwd",1);
        }else{
            View::assign("has_tgwd",0);
        }
        return View::fetch();
    }

    public function user_chengjiu_history(){
        //session安全检查
        session_safe_user();
        //接收page
        $page = Request::param('page');
        //分页查询数据
        $username = Session::get('username');
        $where = [
            'username' => $username
        ];
        $list = Db::name('chengjiu')->where($where)
        ->order('id','desc')
        ->paginate(10);
        $count = $list->total();
        //赋值
        View::assign("nowpage",$page);
        View::assign("list",$list);
        View::assign("total",$count);
        return View::fetch();
    }

    public function userinfo(){
        load_lanmu_session();
        
        //接收ID
        $id = Request::param('id');
        $where= [
            'id' => $id
        ];
        $info_user = Db::name('user')->where($where)->find();
        if(!$info_user){
            header('location:/');
            exit;
        }
        View::assign("info_user",$info_user);
        return View::fetch();
    }

    

    public function forget_password(){
        load_lanmu_session();
        return View::fetch();
        
    }

    public function set_password(){
        //重置密码session保护
        $reset_password_user = Session::get('reset_password_user');
        if($reset_password_user==""){
            echo "<script>window.location.href='/'</script>";
            exit;  
        }

        load_lanmu_session();

        View::assign("reset_user",$reset_password_user);
        return View::fetch();

    }

    public function about(){
        load_lanmu_session();
        //接收ID
        $id = Request::param('id');
        View::assign("id",$id);
        return View::fetch();

    }

    public function p1()
    {
        return View::fetch('index/about/p1');
    }
    public function p2()
    {
        return View::fetch('index/about/p2');
    }
    public function p3()
    {
        return View::fetch('index/about/p3');
    }
    public function p4()
    {
        return View::fetch('index/about/p4');
    }
    public function p5()
    {
        return View::fetch('index/about/p5');
    }
    



    
}
