<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;
use think\facade\Request;
use think\facade\Session;
use think\facade\View;
use app\validate\User;
use think\exception\ValidateException;
use think\facade\Token;
use think\Collection;







class Admin extends BaseController
{
    /* 退出系统 */
    public function exit()
    {
        Session::delete('user');
        return redirect('login0306.html');
    }

    
    /** 1、界面模块 **/

    /*1.1 登录 */
    public function login0306()
    {
        return View::fetch();
    }
    
    /*1.2 管理中心 */
    public function home()
    {
        $user = session_safe();
        View::assign("user",$user);
        return View::fetch('home');
    }
    
    /*1.3 欢迎 */
    public function welcome()
    {
        session_safe();
        View::assign("date",date("Y年n月j日"));
        return View::fetch();
    }
    
    /*1.4 添加文章 */
    public function article_add()
    {
        session_safe();
        //查询栏目信息
        $info1 = Db::name('class')->where('father_id',0)->field('id,name')->order('sort','asc')->select();
        $count_class = count($info1);
        if($count_class==0){
            return '没有栏目数据，请先添加栏目信息。';
        }
        $arr_show = $info1->toArray();
        $count1 = count($info1);
       
        for($i=0;$i<$count1;$i++){
            $info2 = Db::name('class')->where('father_id',$info1[$i]['id'])->field('id,name')->order('sort','asc')->select();
            $arr_show2 = $info2 -> toArray();
            $arr_show[$i]['children'] = $arr_show2;
        }
        
        View::assign("info_class",$arr_show);
        return View::fetch();
    }

    /*1.5 管理文章 */
    public function article_admin()
    {  
        session_safe();
        //接收page
        $nowpage = Request::param('page');
        View::assign("nowpage",$nowpage);

        //分页数据查询
        $where = array(
            'flag' => 1
        );
        $list = Db::name('article')->where($where)
        ->alias('a')
        ->join('class c','a.class = c.id')
        ->field('a.id,a.title,a.date,c.name,c.father_id,c.father_name,a.answer,a.views,a.collect,a.zhuti,a.question_nums,a.thumb')
        ->order('a.id','desc')
        ->paginate(15);
        //赋值
        View::assign("list",$list);
        return View::fetch();
    }

    /*1.6 文章草稿箱 */
    public function article_draft()
    {
        session_safe();
        return View::fetch();
    }

    /*1.7 添加栏目 */
    public function class_add()
    {
        session_safe();
        return View::fetch();
    }

    /*1.8 显示一级栏目 */
    public function class_admin()
    {
        session_safe();
        $info = Db::name('class')->where('father_id', 0)->order('sort', 'asc')->select();
        // 将集合转换为数组
        $infoArray = $info->toArray();
        $count = count($info);

        for($i = 0;$i < $count;$i++){
            $id = $infoArray[$i]['id'];
            $has_child = Db::name('class')->where('father_id',$id)->field('id')->select();
            $count2 = count($has_child);
            if($count2 > 0){
                $infoArray[$i]['has_child'] = 1;
            }else{
                $infoArray[$i]['has_child'] = 0;
            }
        }
   
        View::assign("info",$infoArray);
        return View::fetch();
    }

    /*1.9 修改栏目 */
    public function class_update()
    {
        session_safe();
        $a = Request::param('id');
        $info = Db::name('class')->where('id',$a)->find();
        View::assign("info",$info);
        return View::fetch();
    }

    /*1.10 添加下级栏目 */
    public function class_add_child()
    {
        session_safe();
        $a = Request::param('id');
        View::assign("id",$a);
        return View::fetch();
    }

    /*1.11 显示二级栏目 */
    public function class_child_admin()
    {
        session_safe();
        $a = Request::param('id');
        $info = Db::name('class')->where('father_id',$a)->order('sort', 'asc')->select();
        View::assign("info",$info);
        return View::fetch();
    }

    /*1.12 文章修改 */
    public function article_update()
    {
        session_safe();
        $id = Request::param('id');
        $nowpage = Request::param('page');
        $now_page_caogao = Request::param('now_page_caogao');
        $flag = Request::param('flag');

        //查询栏目信息
        $info1 = Db::name('class')->where('father_id',0)->field('id,name')->select();
        
        $arr_show = $info1->toArray();
        $count1 = count($info1);
       
        for($i=0;$i<$count1;$i++){
            $info2 = Db::name('class')->where('father_id',$info1[$i]['id'])->field('id,name')->select();
            $arr_show2 = $info2 -> toArray();
            $arr_show[$i]['children'] = $arr_show2;
        }
        
        //查询文章ID
        $info_article = Db::name('article')->where('id',$id)->find();

        //查询文章ID的栏目name
        $info_article_class = Db::name('class')->where('id',$info_article['class'])->field('name')->find();

        View::assign("nowpage",$nowpage);
        View::assign("now_page_caogao",$now_page_caogao);
        View::assign("flag",$flag);
        View::assign("info_article_class",$info_article_class['name']);
        View::assign("info_class",$arr_show);
        View::assign("info_article",$info_article);
        return View::fetch();
        
    }

    /*1.13 草稿箱 */
    public function article_caogao()
    {
        
        session_safe();
        //接收page
        $nowpage = Request::param('page');
        View::assign("nowpage",$nowpage);
        
        //分页数据查询
        $where = array(
            'flag' => 0
        );
        $list = Db::name('article')->where($where)
        ->alias('a')
        ->join('class c','a.class = c.id')
        ->field('a.id,a.title,a.date,c.name,c.father_id,c.father_name,a.views,a.zhuti,a.collect,a.zhuti,a.question_nums,a.thumb')
        ->order('a.id','desc')
        ->paginate(10);
        //赋值
        View::assign("list",$list);
        return View::fetch();
    }

    /*1.14 文章搜索 */
   public function article_search()
   {
       session_safe();
       $id = Request::param('id');
              
       // 根据主键搜索
       $result = Db::name('article')->where('id',$id)->field('id,title,is_article')->find();
       if($result){
        View::assign("info",$result);
        View::assign("is_has",1);
       }else{
        View::assign("is_has",0);
       }
       return View::fetch();
       
       
   }

    public function wendang_anquan()
    {
        session_safe();
        return View::fetch('admin/wendang/wendang_anquan');
    }

    public function wendang_chengjiuzhi()
    {
        session_safe();
        return View::fetch('admin/wendang/wendang_chengjiuzhi');
    }

    public function password()
    {
        session_safe();
        return View::fetch();
    }

    /* 用户管理 */
    public function user_admin()
    {
        session_safe();
        //分页数据
        $list = Db::name('user')
        ->order('id','desc')
        ->paginate(1);

        //分页赋值
        View::assign("list",$list);

        return View::fetch();
    }



    public function zhenyan_add()
    {
        session_safe();
        return View::fetch();
    }

    public function zhenyan_admin()
    {
        session_safe();
        //接收page
        $nowpage = Request::param('page');
        View::assign("nowpage",$nowpage);

        //查询
        $list = Db::name('zhenyan')
        ->order('id','desc')
        ->paginate(15);

        //分页赋值
        View::assign("list",$list);
        return View::fetch();
    }

    public function rili_add()
    {
        session_safe();
        return View::fetch();
    }

    public function rili_admin()
    {
        session_safe();
        //接收page
        $nowpage = Request::param('page');
 
        //查询
        $list = Db::name('rili')
        ->order('id','desc')
        ->paginate(15);

        //分页赋值
        View::assign("nowpage",$nowpage);
        View::assign("list",$list);
        return View::fetch();
    }


    /* answer add */
    public function answer_add()
    {
        session_safe();
       
        $id = Request::param('id');
        $info = Db::name('article')->where('id',$id)->field('title,answer')->find();
        $title = $info['title'];
        $answer = $info['answer'];
        View::assign("id",$id);
        View::assign("title",$title);
        View::assign("answer",$answer);
        return View::fetch();
    }

    

     
    



    

    





}