<?php
namespace app\common_class;
use think\facade\Db;
use think\facade\View;
use think\facade\Request;

class PageUser
{
    public $offset = 10;//每页条数
    public $total;//信息总数
    public $totalPage;//页数
    public $nowPage;//当前页码
    public $start;//limit起始
    
    
  
    public function __construct() {
        $page = Request::param('page');
        if($page == ""){
            $page = 1;
        }
        $this->nowPage = $page;
        $this->start = $this->offset * ($this->nowPage - 1);
        
    }
    
   

    public function pageQuery()
    { 
       
        $info = Db::name('user')
        ->limit($this->start,$this->offset)
        ->order('id','desc')
        ->select();
        $count = Db::name('user')->count();
        //信息总数
        $this->total = $count;
        //总页数计算
        $a = ceil($this->total/$this->offset);
        $b = (int)$a;
        $this->totalPage = $b;

        //模板赋值
        View::assign("now_page",$this->nowPage);
        View::assign("total",$this->total);
        View::assign("totalpages",$this->totalPage);

        return $info;
    }

   
    public function pageCount(){       
        
        $page_a = "";
        $page_up = "<a id='page_list_up'>上一页</a>";
        $page_down = "<a id='page_list_down'>下一页</a>";

        if($this->totalPage < 11){
            /*页数10以内，全部输出*/
            for($i=1;$i<=$this->totalPage;$i++){
                if($i == $this->nowPage){
                    $page_a = $page_a."<a class='page_list_active'>".$i."</a>";
                }else{
                    $page_a = $page_a."<a class='page_list_normal'>".$i."</a>";
                }    
            } 
        }else{
            /*页数超过10，只输出10个*/
            //当前页面>5
            if($this->nowPage > 5){
                //末尾页面的显示
                if(($this->totalPage - $this->nowPage) <= 5){
                    for($i=$this->totalPage-9;$i<=$this->totalPage;$i++){
                        if($i == $this->nowPage){
                            $page_a = $page_a."<a class='page_list_active'>".$i."</a>";
                        }else{
                            $page_a = $page_a."<a class='page_list_normal'>".$i."</a>";
                        }    
                    }
                }else{
                    //非末尾页面
                    for($i=$this->nowPage-4;$i<=$this->nowPage+5;$i++){
                        if($i == $this->nowPage){
                            $page_a = $page_a."<a class='page_list_active'>".$i."</a>";
                        }else{
                            $page_a = $page_a."<a class='page_list_normal'>".$i."</a>";
                        }    
                    }
                }
                
            }else{
                //当前页面<5
                for($i=1;$i<=10;$i++){
                    if($i == $this->nowPage){
                        $page_a = $page_a."<a class='page_list_active'>".$i."</a>";
                    }else{
                        $page_a = $page_a."<a class='page_list_normal'>".$i."</a>";
                    }    
                }
            }
            
        }
        /* 添加上一页和下一页*/
        if($this->nowPage == 1){
            if($this->totalPage == 1 || $this->total == 0){
                $page_a = $page_a;
            }else{
                $page_a = $page_a.$page_down;
            }
            
        }elseif($this->nowPage == $this->totalPage){
            $page_a = $page_up.$page_a;
        }else{
            $page_a = $page_up.$page_a.$page_down;
        }
        
        /* 返回最终html代码 */
        return $page_a;
    }
   
        



}